import QtQuick 2.0
import QtCharts 2.3
import "../MedComponents"
Item {
    id: root
    signal requestBack()
    signal requestEdit(int row)
    property int index: 0
    Rectangle {
        anchors.fill: parent
        color: "lightgrey"

        Rectangle {
            id: patientInfo
            anchors.left:parent.left
            width: parent.width * 0.5
            height: parent.height * 0.45
            color: "darkgrey"
            Text {
                id: lblInfo
                font.pixelSize: parent.height * 0.13
                text: "Patient Info"
            }
            Column {
                anchors.fill: parent
                anchors.topMargin: lblInfo.paintedHeight
                anchors.margins: 6
                Text {
                    id: lblName
                    font.pixelSize: parent.height * 0.13
                    text: "Name: " + dataModel.roleFromRow(index, "lastName") + ", " + dataModel.roleFromRow(index, "firstName")
                }

                Text {
                    id: lblDob
                    font.pixelSize: parent.height * 0.13
                    text: "D.O.B: " + dataModel.roleFromRow(index, "dob")
                }
                Text {
                    id: lblAddress
                    font.pixelSize: parent.height * 0.13
                    text: {
                        "Address\n  " +
                                dataModel.roleFromRow(index, "address") + "\n  " +
                                dataModel.roleFromRow(index, "city") + ", " + dataModel.roleFromRow(index, "state") + " " + dataModel.roleFromRow(index, "zipCode")
                    }
                }
            }
        }
        Rectangle {
            id :commentBox
            anchors.left: patientInfo.right
            anchors.right: parent.right
            anchors.top: parent.top
            anchors.bottom: weightContainer.top
            color: "darkgrey"
            Text {
                id: lblComment
                font.pixelSize: parent.height * 0.13
                text: "Comments"
            }
            Rectangle {
                anchors.fill: parent
                anchors.topMargin: lblComment.paintedHeight
                anchors.margins: 6
                Text {
                    anchors.fill: parent
                    text: dataModel.roleFromRow(index, "comments")
                }
            }
        }

        ChartView {
            id: weightContainer
            anchors.top: patientInfo.bottom
            anchors.bottom: btnEdit.top
            anchors.left: parent.left
            anchors.right: parent.right
            antialiasing: true
        }

        Button {
            id: btnEdit
            anchors.bottom: parent.bottom
            anchors.right: parent.right
            height: parent.height * 0.1
            text: "Edit"
            onClicked: root.requestEdit(index)
        }

        Button {
            anchors.bottom: parent.bottom
            anchors.left: parent.left
            anchors.right: btnEdit.left
            height: parent.height * 0.1
            text: "Back to List"
            onClicked: root.requestBack()
        }
    }

    onIndexChanged: {
        weightContainer.removeAllSeries()
        var weightData = dataModel.roleFromRow(index, "weightData").split(",")
        var i
        weightContainer.createSeries(ChartView.SeriesTypeSpline, "Patient Weight", createAxis(0, (weightData.length -2 )), createAxis(50, 350))
        for(i = 0; i < weightData.length -1; i++)
            weightContainer.series(0).append(i, weightData[i])
    }

    function createAxis(min, max) {
        return Qt.createQmlObject("import QtQuick 2.0; import QtCharts 2.0; ValueAxis { min: " + min + "; max: " + max + " }", weightContainer);
    }
}
